-- --------------------------------------------------------------------
--  20190115
-- --------------------------------------------------------------------
--  Replace the trigger on the Historic table to act upon update.
-- --------------------------------------------------------------------

-- Drop the insertion based trigger
IF EXISTS(SELECT * FROM sysobjects WHERE type = 'TR' AND name = 'VX_TR_HistoricResponse_Insert')
BEGIN
  DROP TRIGGER [dbo].[VX_TR_HistoricResponse_Insert]
END
GO


-- Drop the update based trigger
IF EXISTS(SELECT * FROM sysobjects WHERE type = 'TR' AND name = 'VX_TR_HistoricResponse')
BEGIN
  DROP TRIGGER [dbo].[VX_TR_HistoricResponse]
END
GO


CREATE TRIGGER [dbo].[VX_TR_HistoricResponse]
   ON  [dbo].[Historic]
   AFTER UPDATE
AS 
BEGIN
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
-- From the Installation configuration, the option for Audit of the Response table.
  INSERT INTO dbo.HistoricResponse 
     (Respondent, CallId, Question, Matrix, Mention, Content, OpenEnd, ModifiedBy, Modified)
    SELECT inserted.HisRespondent, inserted.HisCallNumber, r.RpsQuestion, r.RpsMatrix, r.RpsMention, r.RpsContent, r.RpsOpened, r.modifiedby, r.modified
    FROM inserted
    join Response r on  r.RpsRespondent = inserted.HisRespondent
    WHERE EXISTS (SELECT 1 FROM Installation WHERE INSSECTION = 'TRACKHISTORICRESPONSE' and INSIDENT LIKE 'QUESTION![%!]' ESCAPE '!' and INSVALUE = r.RpsQuestion)
    AND r.RpsType = 0
    AND inserted.IsImported = 0
END
GO

ALTER TABLE [dbo].[Historic] ENABLE TRIGGER [VX_TR_HistoricResponse]
GO
